﻿/*
	VERSION:		1.1
	
	WHAT IS THIS:
		This places a sprite on the map's sprite layer, 
		with appearance specified,
		and location based on the sprite marker.
		
	NOTE:
		Call this only once.
*/
_global.placeSprite = function( spriteProg_mc, charset, pose, dir, anim, name, spriteLayer )
{
	// resolve optional parameters
	// spriteProg_mc		(must be supplied)
	// charset			(must be supplied)
	var pose = (pose!=undefined) ? pose : 0;
	var dir = (dir!=undefined) ? dir : 2;
	var anim = (anim!=undefined) ? anim : false;
	var name = (name) ? name : "person_"+Math.floor(Math.random()*999);		// person_962
	var spriteLayer = (spriteLayer) ? spriteLayer : SPRITES_MC;
	while( spriteLayer[name] ){
		name = "person_"+Math.floor(Math.random()*999);		// person_962
	}
	
	var _this = spriteProg_mc._this = spriteLayer.createEmptyMovieClip( name, nextDepth(spriteLayer) );
	#include "functions/makeSprite.as"
	var image_mc = makeSprite( _this, charset, "image_mc" );
	image_mc._x = 8;
	image_mc._y = 7;
	_this._x = spriteProg_mc._x;
	_this._y = spriteProg_mc._y;
	
	// set appearance
	image_mc.setPose( pose );
	image_mc.setAnim( anim );
	image_mc.setDirection( dir );
	
	
	// add talk event system
	#include "functions/scriptSystem.as"
	spriteProg_mc.talkEvents = makeScriptSystem( _this );		// talk script
	spriteProg_mc.move = makeScriptSystem( _this );		// movement script
}// placeSprite()